# Meteoprog sublet file
# Created with sur-0.2
require 'net/http';
require 'cgi'

configure :meteoprog do |s|
  s.interval = s.config[:interval] || 1
  s.location    = s.config[:location] || "Lviv"
end

on :run do |s|
  uri = URI("http://www.meteoprog.ua/ua/weather/#{URI.escape(s.location)}/")
  http = Net::HTTP.new(uri.host, 80)
  request = Net::HTTP::Get.new(uri.request_uri)
  cookie = CGI::Cookie.new('mobile', '1')
  request['Cookie'] = cookie.to_s 
  deg = http.request(request).body[/temp"\>(.+)&/,1].to_i
  if deg > 0
    deg = "+#{deg}"
  end
  s.data = "#{s.location}: #{deg}°C"
end
