# -*- encoding: utf-8 -*-
# Betternotify specification file
# Created with sur-0.2
Sur::Specification.new do |s|
  # Sublet information
  s.name        = "Betternotify"
  s.version     = "0.1"
  s.tags        = [ "Notify", "Window", "FFI", "DBus", "Icon", "Config" ]
  s.files       = [ "betternotify.rb" ]
  s.icons       = [ "icons/info.xbm" ]

  # Sublet description
  s.description = "Display libnotify messages with body"
  s.notes            = <<NOTES
This sublet is 99% copied from unexists notify, but i added libnotify body 
(unlimited length) and changed length of subject to 70 characters. Also i
changed from mouse over/out to click. Beside that i changed the positioning, 
so that for some users it is possibly incorrect, but the old one did not work 
for me...

This sublet replaces the current libnotify handler, it collects messages and
basically consists of an icon and a message window. Once a message is received
the icon changes its color to the highlight color. By clicking on the
sublet, the message window will be visible beneath the sublet and the messages
can be read. When the icon is clicked again the message window disappears
again and all messages are discarded.
NOTES

  # Sublet authors
  s.authors     = [ "loopback", "unexist" ]
  s.contact     = "myflaar@gmail.com"
  s.date        = "Tue Aug 30 12:20 CEST 2011"

  # Sublet config
  s.config           = [
    {
      :name        => "font",
      :type        => "string",
      :description => "Window font",
      :def_value   => "-*-fixed-*-*-*-*-10-*-*-*-*-*-*-*",
    },
    {
      :name        => "foreground",
      :type        => "string",
      :description => "Foreground color of the window (#rrggbb)",
      :def_value   => "sublets_fg",
    },
    {
      :name        => "background",
      :type        => "string",
      :description => "Background color of the window (#rrggbb)",
      :def_value   => "sublets_bg",
    },
    {
      :name        => "highlight",
      :type        => "string",
      :description => "Highlight color of the icon (#rrggbb)",
      :def_value   => "focus_fg",
    }
  ]
  
  # Sublet requirements
  s.required_version = "0.9.2127"
  s.add_dependency("ffi", ">=0.5.4")
end
