# Arbi_battery sublet file
# Created with sur-0.2
require 'arbi'

configure :arbi_battery do |s|
  s.interval = 2
  s.icons = {
    full:   Subtlext::Icon.new('bat_full.xbm'),
    low:    Subtlext::Icon.new('bat_low.xbm'),
    empty:  Subtlext::Icon.new('bat_empty.xbm')
  }
  Arbi.connect
end

on :run do |s|
  begin
    batteries = Arbi.get('battery').data

    avg = batteries.select {|x|
      x['name'] == 'AVERAGE'
    }.first['percent'].gsub(/%/, '').to_f

    batteries = batteries.select {|x|
      x['name'] != 'AVERAGE'
    }

    s.data = s.icons[avg < 16 ? :empty : (avg < 51 ? :low : :full)].to_s + batteries.map {|x|
      x['percent']
    }.join(' | ')
  rescue Exception => e
    s.data = ""
    STDERR.puts(e.to_s + "\n" + e.backtrace.join("\n") + "\n")
  end
end
