# Arbi_battery sublet file
# Created with sur-0.2.165
require 'arbi'

configure :arbi_battery do |s|
    Arbi.connect

    s.interval = 10
    s.icons = {
        :ac       => Subtlext::Icon.new("ac.xbm"),
        :full     => Subtlext::Icon.new("bat_full.xbm"),
        :low      => Subtlext::Icon.new("bat_low.xbm"),
        :empty    => Subtlext::Icon.new("bat_empty.xbm")
  }
end

on :run do |s|
    begin
        battery = Arbi.get("batteries").to_a.first.last
        if battery == {'sanity' => false, 'state' => false, 'percent' => false}
            s.data = s.icons[:ac] + " AC"
        else
            s.data = "#{s.icons[case battery['state']
                when 'charging', 'charged' then :ac
                when 'discharging'
                    case battery['percent'].gsub(/%/, '').to_i
                        when 67..100 then :full
                        when 34..66 then :low
                        when 0..33 then :empty
                    end
            end]} #{battery['percent']}"
        end
    rescue e
        s.data = "#{s.icons[:ac]} AC"
        p e
    end
end
