# Multi_Battery sublet file
# Created with sur-0.2
configure :multibattery do |s|
  paths = Dir[s.config[:path] || "/sys/class/power_supply/B*"]

	s.batteries = []
	s.interval = s.config[:interval]

	paths.each do |path|
		now = ""
		full = ""

		if(File.exist?(File.join(path, "charge_full")))
			full = "charge_full"
			now  = "charge_now"
		elsif(File.exist?(File.join(path, "energy_full")))
			full = "energy_full"
			now  = "energy_now"
		end
		s.batteries.push([File.join(path, now), IO.readlines(File.join(path, full)).first.to_i])
	end
	s.x = 1
end

on :run do |s|
	begin
		data = ""
		s.batteries.each do |b|
 		 	data += "%d%% " % (IO.readlines(b.first).first.to_i * 100 / b.last).to_i
		end
	rescue
		data = "ERR"
		p 'error running multibattery'
	end
	s.data = data
end

